/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.debuff;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.client.render.debuff.IDebuffRenderer;
import dev.toma.gunsrpg.common.debuffs.IStagedDebuff;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.math.Mth;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class IconDebuffRenderer<D extends IStagedDebuff>
implements IDebuffRenderer<D> {
    public static final ResourceLocation POISON_ICON = IconDebuffRenderer.icon("poison");
    public static final ResourceLocation INFECTION_ICON = IconDebuffRenderer.icon("infection");
    public static final ResourceLocation FRACTURE_ICON = IconDebuffRenderer.icon("fracture");
    public static final ResourceLocation BLEED_ICON = IconDebuffRenderer.icon("bleed");
    private final ResourceLocation iconTexture;
    private final RenderControls controls;

    public IconDebuffRenderer(ResourceLocation iconTexture) {
        this(iconTexture, RenderControls.getDefault());
    }

    public IconDebuffRenderer(ResourceLocation iconTexture, RenderControls controls) {
        this.iconTexture = iconTexture;
        this.controls = controls;
    }

    private static ResourceLocation icon(String name) {
        return GunsRPG.makeResource(String.format("textures/icons/%s.png", name));
    }

    @Override
    public void drawOnScreen(D debuff, IAttributeProvider attributes, MatrixStack poseStack, int left, int top, int width, int height, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager manager = mc.func_110434_K();
        Matrix4f pose = poseStack.func_227866_c_().func_227870_a_();
        FontRenderer font = mc.field_71466_p;
        int transparency = -2013265920;
        int addProgress = Math.min(debuff.ticksSinceAdded(), this.controls.addEffectTime);
        float backgroundSlideIn = Mth.asLinearInterpolatedFunction(addProgress, 0, this.controls.slideInTime, partialTicks);
        RenderUtils.drawGradient(pose, left, top, left + (int)((float)width * backgroundSlideIn), top + height, transparency, transparency);
        float contentFadeIn = Mth.asLinearFunction(addProgress, this.controls.slideInTime, this.controls.slideInTime + this.controls.contentFadeIn);
        int textFadeIn = Math.max(4, (int)(contentFadeIn * 255.0f));
        int colorFadeInEffect = (int)(contentFadeIn * 255.0f);
        int iconFadeIn = (int)(contentFadeIn * 255.0f) << 24;
        manager.func_110577_a(this.iconTexture);
        RenderUtils.drawColoredTex(pose, left + 2, top + 2, left + 18, top + 18, 0xFFFFFF | iconFadeIn);
        boolean isDisabled = debuff.isFrozen(attributes);
        String text = this.getDebuffText(debuff);
        int textWidth = font.func_78256_a(text);
        int resultColor = this.getTextColor(debuff, textFadeIn, colorFadeInEffect, isDisabled);
        if (isDisabled) {
            float progress = debuff.getBlockingProgress(attributes);
            RenderUtils.drawSolid(pose, left, top + height - 1, left + (int)((float)width * progress), top + height, -16724992);
        }
        font.func_238421_b_(poseStack, text, (float)(left + width - 5 - textWidth), (float)top + 6.5f, resultColor);
    }

    protected String getDebuffText(D debuff) {
        return debuff.getCurrentProgress() + " %";
    }

    protected int getTextColor(D debuff, int textFadeIn, int colorFadeIn, boolean isDisabled) {
        int damageProgress;
        boolean isHealing;
        int healProgress = debuff.ticksSinceHealed();
        boolean bl = isHealing = healProgress < (damageProgress = debuff.ticksSinceProgressed()) && healProgress < 15;
        if (isDisabled) {
            return 65280;
        }
        if (isHealing) {
            float effect = Mth.asLinearFunction(healProgress, 0, this.controls.effectLength);
            int clr = Math.min((int)(effect * 255.0f), colorFadeIn);
            return RenderUtils.combine4i(clr, 255, clr, textFadeIn);
        }
        float effect = Mth.asLinearFunction(damageProgress, 0, this.controls.effectLength);
        int clr = Math.min((int)(effect * 255.0f), colorFadeIn);
        return RenderUtils.combine4i(255, clr, clr, textFadeIn);
    }

    public static class RenderControls {
        private static final RenderControls DEFAULT_CONTROLS = new RenderControls(35, 20, 25);
        private final int addEffectTime;
        private final int slideInTime;
        private final int contentFadeIn;
        private final int effectLength;

        public RenderControls(int addEffect, int slideIn, int effect) {
            this.addEffectTime = addEffect;
            this.slideInTime = slideIn;
            this.contentFadeIn = addEffect - slideIn;
            this.effectLength = effect;
        }

        public static RenderControls getDefault() {
            return DEFAULT_CONTROLS;
        }
    }
}

